VERSION 5.00
Object = "{C3347FBA-4070-498B-A391-1D5EDA6E0448}#1.0#0"; "ComiLxAx.ocx"
Begin VB.Form main 
   Caption         =   "UnLimited Scan"
   ClientHeight    =   5175
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   12975
   LinkTopic       =   "Form1"
   ScaleHeight     =   5175
   ScaleWidth      =   12975
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame3 
      Caption         =   " Result "
      Height          =   4455
      Left            =   5520
      TabIndex        =   9
      Top             =   480
      Width           =   7095
      Begin VB.CommandButton btnResume 
         Caption         =   "Resume"
         Enabled         =   0   'False
         Height          =   405
         Left            =   4320
         TabIndex        =   20
         Top             =   240
         Width           =   1425
      End
      Begin VB.TextBox txtResult 
         Height          =   3510
         Left            =   270
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   19
         Top             =   780
         Width           =   6555
      End
      Begin VB.ComboBox comViewChannel 
         Enabled         =   0   'False
         Height          =   315
         Left            =   2550
         Style           =   2  'Dropdown List
         TabIndex        =   12
         Top             =   300
         Width           =   1395
      End
      Begin VB.Label Label5 
         Alignment       =   1  'Right Justify
         Caption         =   "View Channel :"
         Height          =   315
         Left            =   1110
         TabIndex        =   11
         Top             =   345
         Width           =   1245
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   " Configuration "
      Height          =   3015
      Left            =   360
      TabIndex        =   4
      Top             =   1920
      Width           =   5055
      Begin VB.TextBox txtNumData 
         Enabled         =   0   'False
         Height          =   330
         Left            =   2145
         TabIndex        =   16
         Text            =   "1000"
         Top             =   1890
         Width           =   1650
      End
      Begin VB.TextBox txtFrequency 
         Enabled         =   0   'False
         Height          =   330
         Left            =   2160
         TabIndex        =   15
         Text            =   "10000"
         Top             =   1370
         Width           =   1605
      End
      Begin VB.CommandButton btnStart 
         Caption         =   "Start"
         Enabled         =   0   'False
         Height          =   375
         Left            =   765
         TabIndex        =   14
         Top             =   2475
         Width           =   1455
      End
      Begin VB.CommandButton btnStop 
         Caption         =   "Stop"
         Enabled         =   0   'False
         Height          =   375
         Left            =   2595
         TabIndex        =   13
         Top             =   2460
         Width           =   1455
      End
      Begin VB.ListBox lstChannel 
         Columns         =   4
         Enabled         =   0   'False
         Height          =   285
         ItemData        =   "main.frx":0000
         Left            =   2160
         List            =   "main.frx":0002
         Style           =   1  'Checkbox
         TabIndex        =   10
         Top             =   895
         Width           =   2265
      End
      Begin VB.ComboBox comInputRange 
         Enabled         =   0   'False
         Height          =   315
         ItemData        =   "main.frx":0004
         Left            =   2160
         List            =   "main.frx":0014
         Style           =   2  'Dropdown List
         TabIndex        =   5
         Top             =   390
         Width           =   1575
      End
      Begin VB.Label Label7 
         Caption         =   "Hz"
         Height          =   210
         Left            =   4110
         TabIndex        =   21
         Top             =   1380
         Width           =   525
      End
      Begin VB.Label Label8 
         Alignment       =   1  'Right Justify
         Caption         =   "Number of Data :"
         Height          =   330
         Left            =   120
         TabIndex        =   18
         Top             =   1890
         Width           =   1665
      End
      Begin VB.Label Label6 
         Alignment       =   1  'Right Justify
         Caption         =   "Frequency :"
         Height          =   330
         Left            =   645
         TabIndex        =   17
         Top             =   1390
         Width           =   1140
      End
      Begin VB.Label Label4 
         Caption         =   "Volt"
         Height          =   450
         Left            =   4110
         TabIndex        =   8
         Top             =   405
         Width           =   360
      End
      Begin VB.Label Label3 
         Alignment       =   1  'Right Justify
         Caption         =   "Input Channel :"
         Height          =   330
         Left            =   540
         TabIndex        =   7
         Top             =   890
         Width           =   1245
      End
      Begin VB.Label Label2 
         Alignment       =   1  'Right Justify
         Caption         =   "Input Range :"
         Height          =   330
         Left            =   495
         TabIndex        =   6
         Top             =   390
         Width           =   1290
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   " Device Load "
      Height          =   1215
      Left            =   360
      TabIndex        =   0
      Top             =   480
      Width           =   5055
      Begin VB.CommandButton btnLoadDevice 
         Caption         =   "LOAD DEVICE"
         Height          =   360
         Left            =   3090
         TabIndex        =   2
         Top             =   465
         Width           =   1695
      End
      Begin VB.ComboBox comDeviceList 
         Height          =   315
         ItemData        =   "main.frx":0047
         Left            =   1365
         List            =   "main.frx":0054
         Style           =   2  'Dropdown List
         TabIndex        =   1
         Top             =   495
         Width           =   1575
      End
      Begin VB.Label Label1 
         Caption         =   "Device List :"
         Height          =   390
         Left            =   285
         TabIndex        =   3
         Top             =   540
         Width           =   1140
      End
   End
   Begin COMILXAXLib.ComiLxAx ComiLxAx 
      Left            =   4035
      Top             =   15
      _Version        =   65536
      _ExtentX        =   800
      _ExtentY        =   800
      _StockProps     =   0
   End
End
Attribute VB_Name = "main"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'*****************************************************************************************
'
'     COMI-LX20x ̽ ø Frame Scan ̴.
'
'   AD Input Range : -1~1  -2~2  -5~5  -10~10 Bipolar
'   REal Time sampling Rate : 5 MHz ~ 20 MHz
'
'*****************************************************************************************

Dim SelectedChList() As Long    'õǾ ä ȣ ϴ 迭
Dim DestBuf() As Double     '͸ ޹ 迭



'**********α׷ ʱȭ************************************
'
'   ̽ COMI-LX201 õǾ ִ · Ѵ.
'   AD Input Range -10V~10V õǾ ִ · Ѵ.
'   ä ϴ ޺ڽ äιȣ Ѵ.
'
'*************************************************************

Private Sub Form_Load()
    comDeviceList.ListIndex = 0
    comInputRange.ListIndex = 3
    For i = 0 To 3
        lstChannel.AddItem (i)
    Next i
End Sub


'**********α׷  *************************************
'
'   btnStopư Enabled Ӽ True ,
'   ,  scan   ĵ ߴѴ.
'   ̽ εϰ α׷ Ѵ.
'
'*************************************************************

Private Sub Form_Unload(Cancel As Integer)
    If (btnStop.Enabled = True) Then Call ComiLxAx.Us2Stop(1)
    ComiLxAx.UnloadDevice
End Sub


'*******************************************************************
'
'   btnLoadDevice_Click() : btnLoadDevice ư ݹԼ
'
'   õ ̽ εѴ.
'   ϸ Input Range ϰ,  Ʈѵ ð · Ѵ.
'
'*******************************************************************

Private Sub btnLoadDevice_Click()
    ComiLxAx.UnloadDevice
    
    Select Case comDeviceList.ListIndex
        Case 0
            ComiLxAx.DeviceID = COMI_LX201
        Case 1
            ComiLxAx.DeviceID = COMI_LX202
        Case 2
            ComiLxAx.DeviceID = COMI_LX203
    End Select

    success = ComiLxAx.LoadDevice
    
    If (success = True) Then
        comInputRange.Enabled = True
        lstChannel.Enabled = True
        txtFrequency.Enabled = True
        txtNumData.Enabled = True
        btnStart.Enabled = True
    Else
        Call MsgBox("ش ̽ ϴ..", vbOKOnly)
    End If
End Sub


'**********************************************************************
'
'   lstChannel_Click() : lstChannel Ʈڽ ݹԼ
'
'   4 ä Ͽ , ޼ ϰ,
'   äμ 3 ϰ ǵ Ѵ.
'   4  ĵ ,   ä ÿ  ø ֱ  ̴.
'
'**********************************************************************

Private Sub lstChannel_Click()
    If (lstChannel.SelCount > 3) Then
        Call MsgBox("Ͻ äμ 3 ʰϿϴ.", vbOKOnly)
        lstChannel.Selected(lstChannel.ListIndex) = False
    End If
End Sub


'**********************************************************************
'
'   txtFrequency_Change() : txtFrequency ؽƮڽ ݹԼ
'
'   ĵϴ ø ӵ ϴ Ʈ̴.
'   ڰ ƴ ڰ ԷµǴ  üũϰ,   üũѴ.
'
'**********************************************************************
Private Sub txtFrequency_Change()
    If (Not IsNumeric(txtFrequency.Text)) Then txtFrequency.Text = 10000
    If (txtFrequency.Text < 1) Then txtFrequency.Text = 1
    If (txtFrequency.Text > 2000000) Then txtFrequency.Text = 2000000
End Sub


'**********************************************************************
'
'   txtNumData_Change() : txtNumData ؽƮڽ ݹԼ
'
'   ĵ Ÿ  ϴ Ʈ̴.
'   ڰ ƴ ڰ ԷµǴ  üũϰ,   üũѴ.
'
'**********************************************************************
Private Sub txtNumData_Change()
    If (Not IsNumeric(txtNumData.Text)) Then txtNumData.Text = 4096
    If (txtNumData.Text < 1) Then txtNumData.Text = 1
    If (txtNumData.Text > 16384) Then txtNumData.Text = 16384
End Sub


'**********************************************************************
'
'   btnStart_Click() : btnStart ư ݹԼ
'
'   õ ä üũ , InputRange ϰ, ĵ Ѵ.
'   Ÿ ޹ 迭 2  ,
'   äκ Ÿ ޹ޱ ̴.
'
'**********************************************************************

Private Sub btnStart_Click()
    If (lstChannel.SelCount < 1) Then
        Call MsgBox("ä õ ʾҽϴ.", vbOKOnly)
        Exit Sub
    End If
    
    btnLoadDevice.Enabled = False
    comDeviceList.Enabled = False
    comInputRange.Enabled = False
    lstChannel.Enabled = False
    txtFrequency.Enabled = False
    txtNumData.Enabled = False
    btnStart.Enabled = False
    btnStop.Enabled = True
    btnResume.Enabled = True
    comViewChannel.Enabled = True
    Select Case comInputRange.ListIndex
        Case 0
            Min = -1: Max = 1
        Case 1
            Min = -2: Max = 2
        Case 2
            Min = -5: Max = 5
        Case 3
            Min = -10: Max = 10
    End Select
    
    ReDim SelectedChList(lstChannel.SelCount - 1)
    ReDim DestBuf(((txtNumData.Text / 4096) + 1) * 4096, lstChannel.SelCount - 1)
    
    For i = 0 To 3
        If (lstChannel.Selected(i)) Then
            SelectedChList(tmp) = i
            Call ComiLxAx.AdSetRange(i, Min, Max)
            comViewChannel.AddItem (i)
            tmp = tmp + 1
        End If
    Next i
    comViewChannel.ListIndex = 0
    
    Call ComiLxAx.Us2Start(lstChannel.SelCount, SelectedChList(0), txtFrequency.Text, (txtNumData.Text / 4096) + 1, 1)
    
End Sub

'**********************************************************************
'
'   btnStop_Click() : btnStop ư ݹԼ
'
'   ĵ ϰ,  ݴ´.
'
'**********************************************************************

Private Sub btnStop_Click()
    Call ComiLxAx.Us2Stop(1)
    comViewChannel.Clear
    comViewChannel.Enabled = False
    comInputRange.Enabled = True
    lstChannel.Enabled = True
    txtFrequency.Enabled = True
    txtNumData.Enabled = True
    btnStop.Enabled = False
    btnStart.Enabled = True
    btnResume.Enabled = False
    comDeviceList.Enabled = True
    btnLoadDevice.Enabled = True
End Sub


'**********************************************************************
'
'   btnResume_Click() : btnResume ư Ʈ ̺Ʈ ڵ鷯
'
'   Resume() , ۿ  Ѵ.
'   äκ, DestBuf(Ÿ, äιȣ)  , ȭ鿡 ش.
'   1 迭 Ͽ,  äο ؼ, Ÿ ޹޾Ƶ 
'   ⿡, äκ Ÿ ޹޴ ø ֱ ̴.
'
'**********************************************************************

Private Sub btnResume_Click()
    btnResume.Enabled = False
    btnStop.Enabled = False
    comViewChannel.Enabled = False
    Call ComiLxAx.Us2Resume
    Do
        If (ComiLxAx.IsBufFull()) Then
            For i = 0 To lstChannel.SelCount - 1
                Call ComiLxAx.Us2RetrvChannel(i, 1, txtNumData.Text, DestBuf(0, i))
            Next i
            For i = 0 To txtNumData.Text - 1
                tmp = tmp & Format(DestBuf(i, comViewChannel.ListIndex), "0.000  ")
            Next i
            Exit Do
        End If
    Loop
      
    txtResult.Text = tmp 'txtResult.text  ڿ ذ ʴ , ó ӵ ̴.
    btnResume.Enabled = True
    btnStop.Enabled = True
    comViewChannel.Enabled = True
End Sub
